using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;
using System.Text.RegularExpressions;
using TABLE = gov.va.med.vbecs.Common.VbecsTables;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;

namespace gov.va.med.vbecs.GUI.controls
{
	/*
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Cameron Taylor</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>1/15/2003</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>
	///Masked text box user control
	///</summary>

	#endregion
	*/

	/// <summary>
	/// 
	/// </summary>
	public enum MaskTypeEnum
	{
		///<summary></summary>
		Phone,
		///<summary></summary>
		Zip
	};


	/// <summary>
	/// Class Masked Text Box
	/// </summary>
	public class MaskedTextBox : GUI.controls.BaseControl
	{

		/// <summary>
		/// 
		/// </summary>
		public static readonly string PhoneRx = @"^\(\d{3}\) \d{3}-\d{4}$";

		/// <summary>
		/// 
		/// </summary>
		public static readonly string ZipRx = @"^\d{5}(-\d{4})?$";

		/// <summary>
		/// Phone GUI Image
		/// </summary>
		public static readonly string PhoneImg = "(___) ___-____";
		/// <summary>
		/// Zip GUI Image
		/// </summary>
		public static readonly string ZipImg = "_____-____";
		/// <summary>
		/// Zip GUI Image Suffics
		/// </summary>
		public static readonly string ImgSuffics = "Img";


		#region Variables


		/// <summary>
		/// Regular expressions container connected to the local file
		/// </summary>
		private readonly Hashtable _regexf; 


		private System.Windows.Forms.TextBox _txtMaskedTextBox;
		private string _sRegExp;
		private string _sMask;
		private string _sDefaultValue;
		private string _sTextValue;
		string _sExceptionMsg;
		//private bool _isZipCode = false;
		private MaskTypeEnum _maskType;

		#endregion

		private System.Windows.Forms.ToolTip ttToolTip;
		private System.ComponentModel.IContainer components;

		#region Properties

		/// <summary>
		/// 
		/// </summary>
		[
			Category("Behavior"),
			Description("MaskType"),
			DefaultValue(""),
			Bindable(false),
			Browsable(true),
		]
		public MaskTypeEnum MaskType
		{
			get { return _maskType; }
		    set
		    {
		        _maskType = value;
                DefineRegularExpression();
		    }
		}



		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/19/2002</CreationDate>
		/// <summary> 
		/// Gets or sets the value of the mask for the text field. Editable at design time
		/// </summary>
		[
		Category("Behavior"),
		Description("Mask"),
		DefaultValue(""),
		Bindable(false),
		Browsable(true),
		]
		public string Mask
		{
			get
			{
				return _sMask; 
			}
			set
			{
				_sMask = value;
                //DefineRegularExpression();
			}
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/19/2002</CreationDate>
		/// <summary>
		/// Gets or sets error message text
		/// </summary>
		[
		Category("Behavior"),
		Description("Error Message"),
		DefaultValue(""),
		Bindable(false),
		Browsable(true),
		]
		public string ErrorMsg
		{
			get
			{
				return _sExceptionMsg; 
			}
			set
			{
				_sExceptionMsg = value;
			}
		}



		#endregion

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/19/2002</CreationDate>
		/// <summary>
		/// MaskedTextBox class constructor
		/// </summary>
		public MaskedTextBox()
		{
			InitializeComponent();
			_sTextValue = String.Empty;

			_regexf = new Hashtable
			{
				//add regular expression
				{MaskTypeEnum.Phone, PhoneRx},
				{MaskTypeEnum.Zip, ZipRx},
				//add image string
				{MaskTypeEnum.Phone + ImgSuffics, PhoneImg},
				{MaskTypeEnum.Zip + ImgSuffics, ZipImg}
			};
			
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/19/2002</CreationDate>
		/// <summary>
		/// Builds the regular expression based on the value of the mask
		/// </summary>
		private void DefineRegularExpression()
		{
            _sDefaultValue = String.Empty;

			if (MaskType.Equals(MaskTypeEnum.Phone))
			{
				_sRegExp = _regexf[MaskTypeEnum.Phone] as string;
				_sDefaultValue = _regexf[MaskTypeEnum.Phone + ImgSuffics] as string;
			}
			else if (MaskType.Equals(MaskTypeEnum.Zip))
			{
				_sRegExp = _regexf[MaskTypeEnum.Zip] as string;
				_sDefaultValue = _regexf[MaskTypeEnum.Zip + ImgSuffics] as string;
			}

            _txtMaskedTextBox.Text = _sDefaultValue;

		}

		/// <summary> 
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Component Designer generated code
		/// <summary> 
		/// Required method for Designer support - do not modify 
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			this._txtMaskedTextBox = new System.Windows.Forms.TextBox();
			this.ttToolTip = new System.Windows.Forms.ToolTip(this.components);
			this.SuspendLayout();
			// 
			// _txtMaskedTextBox
			// 
			this._txtMaskedTextBox.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this._txtMaskedTextBox.Location = new System.Drawing.Point(8, 0);
			this._txtMaskedTextBox.Name = "_txtMaskedTextBox";
			this._txtMaskedTextBox.Size = new System.Drawing.Size(192, 20);
			this._txtMaskedTextBox.TabIndex = 0;
			this._txtMaskedTextBox.Text = string.Empty;
			this._txtMaskedTextBox.KeyDown += new System.Windows.Forms.KeyEventHandler(this._txtMaskedTextBox_KeyDown);
			this._txtMaskedTextBox.KeyPress += new System.Windows.Forms.KeyPressEventHandler(this._txtMaskedTextBox_KeyPress);
			this._txtMaskedTextBox.KeyUp += new System.Windows.Forms.KeyEventHandler(this._txtMaskedTextBox_KeyUp);
			// 
			// MaskedTextBox
			// 
			this.Controls.Add(this._txtMaskedTextBox);
			this.Name = "MaskedTextBox";
			this.Size = new System.Drawing.Size(208, 24);
			this.Leave += new System.EventHandler(this.MaskedTextBox_Leave);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// MaskedTextValidated Event
		/// </summary>
		public event EventHandler MaskedTextValidated;

		/// <summary>
		/// MaskedTextInvalidated Event
		/// </summary>
		public event EventHandler MaskedTextInvalidated;

		/// <summary>
		/// Masked Text Invalidated Event
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		protected virtual void OnMaskedTextValidated(object sender, System.EventArgs e)
		{
			if (MaskedTextValidated != null)
			{
				MaskedTextValidated(sender, e);
			}
		}

		/// <summary>
		/// Masked Text Invalidated Event
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		protected virtual void OnMaskedTextInvalidated(object sender, System.EventArgs e)
		{
			if (MaskedTextInvalidated != null)
			{
				MaskedTextInvalidated(sender, e);
			}
		}

		/// <summary>
		/// Set the tool tip
		/// </summary>
		/// <param name="strRes"></param>
		public void SetToolTip(Common.StrRes.StringResourceItem strRes)
		{
			//CR 2837 - Wrapping SetToolTip() with Active flag setting to avoid tooltip pop-ups without mouse hovering
			this.ttToolTip.Active = false;
			this.ttToolTip.SetToolTip(this._txtMaskedTextBox,strRes.ResString);
			this.ttToolTip.Active = true;
		}

		/// <summary>
		/// Set the tool tip
		/// </summary>
		/// <param name="toolTip"></param>
		public void SetToolTip(string toolTip)
		{
			//CR 2837 - Wrapping SetToolTip() with Active flag setting to avoid tooltip pop-ups without mouse hovering
			this.ttToolTip.Active = false;
			this.ttToolTip.SetToolTip(this._txtMaskedTextBox,toolTip);
			this.ttToolTip.Active = true;
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/19/2002</CreationDate>
		/// <summary>
		/// Leave event handler. Tests validity of text entered
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void MaskedTextBox_Leave(object sender, System.EventArgs e)
		{
			if (_txtMaskedTextBox.Text.Trim() == _sDefaultValue)
			{
				_sTextValue = String.Empty;
				this.OnMaskedTextInvalidated(_sExceptionMsg,System.EventArgs.Empty);
			}
			else if (this._sMask == "#####-####" && _txtMaskedTextBox.Text.IndexOf("_") == 6)
			{
				_txtMaskedTextBox.Text = _txtMaskedTextBox.Text.Replace("_", "0");
				_sTextValue = _txtMaskedTextBox.Text;
				this.OnMaskedTextValidated(string.Empty, System.EventArgs.Empty); 
			}
			else if (_txtMaskedTextBox.Text.IndexOf("_") != -1)
			{
				_txtMaskedTextBox.Text = _sDefaultValue;
				_sTextValue = String.Empty;
				this.OnMaskedTextInvalidated(_sExceptionMsg,System.EventArgs.Empty);
				_txtMaskedTextBox.Focus();
			}
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/19/2002</CreationDate>
		/// <summary>
		/// Sets the value of the textbox
		/// </summary>
		/// <param name="text">Text</param>
		public void SetText(string text)
		{
			if (text == String.Empty || text == null)
			{
				_sTextValue = String.Empty;
				_txtMaskedTextBox.Text = _sDefaultValue;
			}
			else
			{
				_sTextValue = text;
				
				//_txtMaskedTextBox.Text = text; fill in any remaining characters with ____
				string leftover = _sDefaultValue.Substring(text.Length);
				_txtMaskedTextBox.Text = text + leftover;

				//If loading text, key up not called, so validate/invalidate events not thrown
				_txtMaskedTextBox_KeyUp(_txtMaskedTextBox,new KeyEventArgs(Keys.None));
			}
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/19/2002</CreationDate>
		/// <summary>
		/// Gets the value of the textbox
		/// </summary>
		/// <returns></returns>
		public string GetText()
		{
			return _sTextValue;
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/19/2002</CreationDate>
		/// <summary>
		/// Sets read only property of text box
		/// </summary>
		/// <param name="readOnlyIndicator">Read only indicator</param>
		public void SetReadOnly(bool readOnlyIndicator)
		{
			_txtMaskedTextBox.ReadOnly = readOnlyIndicator;
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/19/2002</CreationDate>
		/// <summary>
		/// Key press event handler
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Key press event args</param>
		private void _txtMaskedTextBox_KeyPress(object sender, System.Windows.Forms.KeyPressEventArgs e)
		{
			this.OnKeyPress(e);
			//
			if (e.Handled)
			{
				return;
			}
			//
			this.OnUserActivity();
			if (!_txtMaskedTextBox.ReadOnly)
			{
				string sText;
				int nIndx, nLastIndex;

				sText = _txtMaskedTextBox.Text;
				if (sText == String.Empty)
				{
					sText = _sDefaultValue;
				}

				//backspace removes the last character
				if (e.KeyChar == 8)
				{
					if (sText.Trim() == _sDefaultValue)
					{
						e.Handled = true;
						return;
					}

					nIndx = sText.IndexOf("_");

					//if cursor is positioned at the beginning of the mask
					if (nIndx <= _sDefaultValue.IndexOf("_") && nIndx != -1)
					{
						e.Handled = true;
						return;
					}

					if (nIndx != -1)
					{
						nLastIndex = _sDefaultValue.Substring(0, nIndx).LastIndexOf("_");
					}
					else
					{
						nLastIndex = _sDefaultValue.LastIndexOf("_");
					}
					sText = sText.Remove(nLastIndex, 1);
					sText = sText.Insert(nLastIndex, "_");
					_txtMaskedTextBox.Text = sText;

					_txtMaskedTextBox.Select(nLastIndex, 0);
				}
					//inserting typed character into a proper place on the mask field
				else
				{
					if ((nIndx = sText.IndexOf("_")) != -1)
					{
						sText = sText.Remove(nIndx, 1);
						sText = sText.Insert(nIndx, System.Convert.ToString(e.KeyChar));
						_txtMaskedTextBox.Text = sText;
					}
					else
					{
						_txtMaskedTextBox.Text = sText;
					}

					if (nIndx != -1)
					{
						_txtMaskedTextBox.Select(nIndx+1, 0);
					}
					else
					{
						_txtMaskedTextBox.Select(_txtMaskedTextBox.Text.Length, 0);
					}
				}
				e.Handled = true;
			}
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/19/2002</CreationDate>
		/// <summary>
		/// Key down event handler
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Key event args</param>
		private void _txtMaskedTextBox_KeyDown(object sender, System.Windows.Forms.KeyEventArgs e)
		{
			this.OnKeyDown(e);
			//
			if (e.Handled)
			{
				return;
			}
			//			
			if (!_txtMaskedTextBox.ReadOnly)
			{
				if (e.KeyData == Keys.Delete)
				{
					e.Handled = true;
				}
			}
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/19/2002</CreationDate>
		/// <summary>
		/// Key up event handler
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Key event args</param>
		private void _txtMaskedTextBox_KeyUp(object sender, System.Windows.Forms.KeyEventArgs e)
		{
			this.OnKeyUp(e);
			//
			if (e.Handled)
			{
				return;
			}
			//
			this.OnUserActivity();

			if (!_txtMaskedTextBox.ReadOnly)
			{
				if (_txtMaskedTextBox.Text.IndexOf("_") == -1)
				{
					if (_txtMaskedTextBox.Text.Trim() != _sDefaultValue)
					{
						Regex evalRegEx = new Regex(_sRegExp);
						Match matchObject = evalRegEx.Match(_txtMaskedTextBox.Text);
						//error if evaluation failed
						if (!matchObject.Success || matchObject.Value != _txtMaskedTextBox.Text.Trim())
						{
							_txtMaskedTextBox.Text = _sDefaultValue;
							_sTextValue = String.Empty;
							this.OnMaskedTextInvalidated(_sExceptionMsg,System.EventArgs.Empty);
							_txtMaskedTextBox.Focus();
						}
						else
						{
							_sTextValue = _txtMaskedTextBox.Text.Trim();
							this.OnMaskedTextValidated(String.Empty,System.EventArgs.Empty);
						}
					}
					else
					{
						_sTextValue = String.Empty;
						this.OnMaskedTextValidated(String.Empty,System.EventArgs.Empty);
					}
				}
			}
		}
	}
}


